<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\CommonHelper;
use App\Http\Controllers\Controller;
use App\Jobs\RecomputeProductRatingJob;
use App\Models\Notification;
use App\Models\ProductReview;
use Illuminate\Http\Request;
use Throwable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ReviewController extends Controller
{
    public function index(Request $request)
    {
        $reviews = ProductReview::getPaginatedData($request);
        if ($request->ajax()) {
            return response()->json([
                'data' => view('admin.product.review-pagination', compact('reviews'))->render(),
            ]);
        }
        return view('admin.product.review-listing', compact('reviews'));
    }
    public function show($id)
    {
        $review = ProductReview::with(['customer', 'product', 'attachments'])
            ->where('id', $id)
            ->first();
        if (!$review) {
            return CommonHelper::jsonResponseWeb(400, __('no_review_found'));
        }
        // set notification to 1
        Notification::where('receiver_id', auth()->id())
            ->where('receiver_type', ADMIN)
            ->where('data->review_id', $review->id)
            ->where('is_read', 0)
            ->update(['is_read' => 1]);
        return view('admin.product.review-show', compact('review'));
    }
    //update status : approve/reject
    public function update(Request $request, $id)
    {


        $validation = Validator::make($request->all(), [
            'status' => 'required|integer|in:1,2',


        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        $review = ProductReview::with('product')->findOrFail($id);
        try {
            $review->status = $request->status;
            $review->save();
            //dispatch job
            RecomputeProductRatingJob::dispatch($review->product->id);

            $extra = [
                'redirect' => route('admin.product.review.show', $id),
            ];
            $statusText = CommonHelper::$approvalStatuses[$request->status];
            return CommonHelper::jsonResponseWeb(200, __('review_status_updated', ['status' => $statusText]), [], $extra);
        } catch (Throwable $e) {

            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
}
