<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\CommonHelper;
use App\Http\Controllers\Controller;
use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Throwable;

class BannerController extends Controller
{
    public function index(Request $request)
    {
        $banners = Banner::pagination($request);
        if ($request->ajax()) {
            return response()->json(['data' => view('admin.banner.pagination', compact('banners'))->render()]);
        }
        // if ($request->ajax()) {
        //     return response()->json([
        //         'data' => view('admin.employee.pagination', compact('employees'))->render()
        //     ]);
        // }

        return view('admin.banner.index', compact('banners'));
    }
    public function create()
    {
        $usedSortOrders = Banner::pluck('sort_order')->toArray();

        $maxSort = Banner::where('status', 1)->max('sort_order') ?? 0;
        $maxSortCount = $maxSort + 1;
        return view('admin.banner.create', compact('usedSortOrders', 'maxSortCount'));
    }
    public function store(Request $request)
    {

        try {
            $videoPoster = null;
            $validation = Banner::validation($request->all());
            if ($validation->fails()) {
                return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
            }

            $file = $request->file('file');
            //get file extension
            $fileExtension = $file->getClientOriginalExtension();
            //get file type
            $fileType = CommonHelper::getMultimediaType($fileExtension);
            $file_path = CommonHelper::fileUpload($request->file('file'), BANNER_FILE_PATH);


            if ($request->filled('video_poster')) {
                $videoPoster = CommonHelper::base64ToImage($request->video_poster, BANNER_FILE_PATH);
                $videoPoster = BANNER_FILE_PATH . '/' . $videoPoster;
            }
            Banner::create([
                'media_path' => $file_path,
                'media_type' => $fileType,
                'media_extension' => $fileExtension,
                'status' => $request->status,
                'sort_order' => $request->sort_order,
                'video_poster' => $videoPoster
            ]);
            $extra = [
                'redirect' => route('admin.banner.index'),
            ];
            return CommonHelper::jsonResponseWeb(200, 'Banner created successfully', [], $extra);
        } catch (Throwable $e) {
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function edit($id)
    {
        try {
            $banner = Banner::findOrFail($id);
            $usedSortOrders = Banner::where('id', '!=', $id)->pluck('sort_order')->toArray();
            $maxSortCount = Banner::max('sort_order') ?? 0;
            $maxSortCount += 1; // allow admin to assign one greater than current max
            return view('admin.banner.edit', compact('banner', 'usedSortOrders', 'maxSortCount'));
        } catch (Throwable $e) {
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function update(Request $request, $id)
    {
        try {
            $banner = Banner::findOrFail($id);

            $validation = Banner::validation($request->all(), $id);
            if ($validation->fails()) {
                return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
            }

            $data = $request->except(['file', 'video_poster']);
            $newSortOrder = $request->input('sort_order');


            if ($newSortOrder != $banner->sort_order) {
                $conflictBanners = Banner::where('sort_order', '>=', $newSortOrder)
                    ->where('id', '!=', $id)
                    ->orderBy('sort_order', 'desc')
                    ->get();

                // Shift conflicting banners down
                foreach ($conflictBanners as $conflictBanner) {
                    $conflictBanner->sort_order += 1;
                    $conflictBanner->save();
                }
            }


            if ($request->has('file')) {
                if (!empty($banner->image_path) && file_exists(public_path($banner->image_path))) {
                    unlink(public_path($banner->image_path));
                }
                if (!empty($banner->video_poster) && file_exists(public_path($banner->video_poster))) {
                    unlink(public_path($banner->video_poster));
                }

                $file = $request->file('file');
                $fileExtension = $file->getClientOriginalExtension();
                $fileType = CommonHelper::getMultimediaType($fileExtension);
                $filePath = CommonHelper::fileUpload($file, BANNER_FILE_PATH, $banner->image_path);
                $data['image_path'] = $filePath;
                $data['media_type'] = $fileType;
                $data['media_extension'] = $fileType;

                if ($fileType == VIDEO) {
                    if ($request->filled('video_poster')) {
                        $data['video_poster'] = CommonHelper::base64ToImage($request->video_poster, BANNER_FILE_PATH);
                    }
                }
            }


            $banner->update($data);

            $extra = ['redirect' => route('admin.banner.index')];
            return CommonHelper::jsonResponseWeb(200, 'Banner updated successfully', [], $extra);
        } catch (Throwable $e) {
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function destroy($id)
    {
        try {
            $banner = Banner::findOrFail($id);
            if (!empty($banner)) {
                if ($banner->image_path && file_exists(public_path($banner->image_path))) {
                    unlink(public_path($banner->image_path));
                }
                $banner->delete();
                $extra = ['redirect' => route('admin.banner.index')];
                return CommonHelper::jsonResponseWeb(200, 'Banner deleted successfully', [], $extra);
            }
        } catch (Throwable $e) {
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
}
