<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{
    public function login()
    {
        return view('admin.auth.login');
    }
    public function loginSubmit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
        ]);
        if ($validator->fails()) {
            return redirect()->route('admin.login')->withInput()->withErrors($validator);
        }
        $admin = User::where('email', $request->email)->first();
        if ($admin) {
            if (Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password])) {
                return redirect()->route('admin.dashboard');
            }
            return redirect()->route('admin.login')->withInput()->with('error', 'Either Email or Password is incorrect.');
        }
        return redirect()->route('admin.login')->withInput()->with('error', 'No account found with this email.');
    }
    public function store()
    {
        User::create([
            'name' => 'Super Admin',
            'email' => 'admin@gmail.com',
            'dial_code' => '+95',
            'dial_code_iso' => 'MM',
            'password' => Hash::make('123456'),
            'image' => 'default.png',
            'address' => 'lorem ipsum',
            'description' => 'this is super admin.'
        ]);
    }
    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login')->with('success', 'Logout Successfully');
    }
}
