<?php

namespace App\Console\Commands;

use App\Models\CustomerWholesalePlan;
use Carbon\Carbon;
use Illuminate\Console\Command;

class ExpirePlans extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'plans:expire';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Expire the active plans when duration is finish';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $today = Carbon::now();
        $expiredPlans = CustomerWholesalePlan::where('status', ACTIVE)
            ->where('end_date', '<', $today)
            ->get();
        foreach ($expiredPlans as $plan) {
            $plan->update(['status' => EXPIRED]);
            $this->info("Plan ID {$plan->id} expired.");
        }

        return 0;
    }
}
