@props([
    'url', // route or URL string
    'method' => 'put', // put|post|patch|delete
    'hiddenFields' => [], // ['order_status' => 1]
    'buttonText' => 'Submit', // button label
    'buttonClass' => 'btn btn-primary',
    'icon' => null, // e.g. 'fas fa-check-circle'
    'confirm' => null, // data-confirm value (optional)
])

<form class="ajax-submit-form" data-url="{{ $url }}" data-method="post"
    @if ($confirm) data-confirm="{{ $confirm }}" @endif>
    @csrf
    @method($method)

    @foreach ($hiddenFields as $name => $value)
        <input type="hidden" name="{{ $name }}" value="{{ $value }}">
    @endforeach

    <button type="submit" class="{{ $buttonClass }}">
        @if ($icon)
            <i class="{{ $icon }}"></i>
        @endif
        {{ $buttonText }}
    </button>
</form>
