<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($vehicleTypes) && count($vehicleTypes) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($vehicleTypes as $vehicleType)
                <tr>

                    <td class="text-capitalize">{{ $vehicleType->name }}</td>
                    <td>
                        <span class="badge {{ badgesforStatuses($vehicleType->status) }}">
                            {{ basicStatusesDisplay($vehicleType->status) }}
                        </span>

                    </td>
                    <td>{{ dateInList($vehicleType->created_at) }}</td>
                    <td class="{{ hideAction($vehicleType->status) }}">

                        @canany(['edit-vehicle_type', 'delete-vehicle_type'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can('edit-vehicle_type')
                                        <a class="dropdown-item"
                                            href="{{ route('admin.vehicle-type.edit', $vehicleType->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @can('delete-vehicle_type')
                                        <button data-url="{{ route('admin.vehicle-type.destroy', $vehicleType->id) }}"
                                            data-id="{{ $vehicleType->id }}" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    @endcan
                                </div>
                            </div>
                        @endcan
                    </td>

                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($vehicleTypes) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $vehicleTypes->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    @endif
</table>
