@extends('admin.layouts.app')
@section('title', 'Edit Vehicle Type')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-xxl-8 col-lg-8 col-md-10 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Vehicle Type</h4>

                    </div>
                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.vehicle-type.update', $vehicleType->id) }}"
                            data-method="POST">

                            @method('PUT')
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="basic-default-name"
                                        value={{ old('name', ucfirst($vehicleType->name)) }} />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option {{ old('status', $vehicleType->status) == $key ? 'selected' : '' }}
                                                value="{{ $key }}">{{ $value }}</option>
                                        @endforeach


                                    </select>

                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
