@extends('admin.layouts.app')
@section('title', 'Show Product')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="flex-with-no-align ">
                        <h4 class="title-no-margin">Show Product</h4>
                        @if ((int) $product->is_featured === 1)
                            <span class="badge bg-warning text-dark">Featured
                                <i class="fas fa-star"></i>
                            </span>
                        @endif

                    </div>

                    <div class="card-body px-0">


                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                            <div class="col-sm-10">
                                <input name="name" type="text" class="form-control" id="basic-default-name"
                                    value="{{ old('name', $product->name) }}" readonly />

                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="vehicle_model">Vehicle Models</label>

                            <div class="col-sm-10">
                                <select class="select2 text-capitalize" name="vehicle_model[]" id="vehicle_model"
                                    multiple="multiple" disabled>
                                    @foreach ($vehicleModels as $vehicleModel)
                                        <option class="text-capitalize" value="{{ $vehicleModel->id }}"
                                            {{ in_array($vehicleModel->id, $product->compatibleModels->pluck('id')->toArray()) ? 'selected' : '' }}>
                                            Type: {{ $vehicleModel->vehicleType->name ?? 'N/A' }}
                                            &nbsp;&nbsp;>>&nbsp;&nbsp;
                                            Make: {{ $vehicleModel->vehicleMake->name ?? 'N/A' }}
                                            &nbsp;&nbsp;>>&nbsp;&nbsp;
                                            Model: {{ $vehicleModel->name }}
                                        </option>
                                    @endforeach


                                </select>


                            </div>
                        </div>
                        {{-- <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="price">Price</label>
                                <div class="col-sm-10">
                                    <input name="price" type="number" step="0.01" min="0" class="form-control"
                                        id="price" value="{{ old('price', $product->price) }}" />
                                </div>
                            </div> --}}
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="price">Price</label>
                            <div class="col-sm-3">
                                {{-- <input name="price" type="number" step="0.01" min="0" class="form-control"
                                        id="price" /> --}}
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon13">USD</span>
                                    <input type="number" step="0.01" min="0" name="price_in_usd"
                                        id="price_in_usd" class="form-control" placeholder="" aria-label="price_in_usd"
                                        aria-describedby="basic-addon13"
                                        value="{{ old('price_in_usd', $product->price_in_usd) }}" readonly />

                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon13">MMK</span>
                                    <input type="number" step="0.01" min="0" name="price_in_mmk"
                                        id="price_in_mmk" class="form-control" placeholder="" aria-label="price_in_mmk"
                                        aria-describedby="basic-addon13"
                                        value="{{ old('price_in_mmk', $product->price_in_mmk) }}" readonly />

                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon13">RMB</span>
                                    <input type="number" step="0.01" min="0" name="price_in_rmb"
                                        id="price_in_rmb" class="form-control" placeholder="" aria-label="price_in_rmb"
                                        aria-describedby="basic-addon13"
                                        value="{{ old('price_in_rmb', $product->price_in_rmb) }}" readonly />

                                </div>
                            </div>

                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="images">Inventory</label>
                            <div class="col-sm-10">
                                <div class="d-flex">
                                    <p class="padding-right-10">{{ $product->stock_in_hand }}</p>

                                </div>


                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="images">Featured Image</label>
                            <div class="col-sm-10">

                                @if ($product->featuredImage)
                                    <div class="old-image">

                                        <div class="row">


                                            <div class="col-lg-3 col-md-6 col-sm-12 pb-3">

                                                <img width="200" src="{{ asset($product->featuredImage->image) }}"
                                                    alt="" class="h-200 ">


                                            </div>


                                        </div>


                                    </div>
                                @endif

                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="description">Description</label>
                            <div class="col-sm-10">
                                <textarea readonly name="description" id="description" class="form-control ckeditor" cols="30" rows="10"> {{ old('description', $product->description) }}</textarea>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="status">Status</label>
                            <div class="col-sm-10">
                                <select disabled class="select2" name="status" id="status">
                                    @foreach (CommonStatusesForCrud() as $key => $value)
                                        <option {{ old('status', $product->status) == $key ? 'selected' : '' }}
                                            value="{{ $key }}">{{ $value }}</option>
                                    @endforeach


                                </select>

                            </div>
                        </div>
                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="images">Gallery</label>
                            <div class="col-sm-10">
                                {{-- <input class="form-control" type="file" id="formFileMultiple" multiple /> --}}

                                <div class="old-image">

                                    <div class="row">

                                        @foreach ($product->images as $image)
                                            <div class="col-lg-3 col-md-6 col-sm-12 py-3">
                                                <div class="image-container position-relative image-wrapper"
                                                    data-id="{{ $image->id }}">
                                                    <img width="200" src="{{ asset($image->image) }}" alt=""
                                                        class="h-200 ">

                                                </div>
                                            </div>
                                        @endforeach

                                    </div>


                                </div>
                            </div>
                        </div>


                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')

@endsection
