<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="name" data-order="asc">
                    Name
                    <i id="sort-icon-name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="price_in_usd" data-order="asc">
                    Price in USD
                    <i id="sort-icon-price_in_usd" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="price_in_mmk" data-order="asc">
                    Price in MMK
                    <i id="sort-icon-price_in_mmk" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Featured</th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($products) && count($products) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($products as $product)
                <tr>

                    <td class="text-capitalize">{{ $product->name }}</td>
                    <td class="">{{ $product->price_in_usd }}</td>
                    <td class="">{{ $product->price_in_mmk }}</td>
                    <td>
                        <span class="badge {{ badgesforStatuses($product->status) }}">
                            {{ basicStatusesDisplay($product->status) }}
                        </span>
                    </td>
                    <td>{{ dateInList($product->created_at) }}</td>
                    <td>
                        @if ((int) $product->is_featured === 1)
                            <span class="badge bg-warning text-dark">Featured
                                <i class="fas fa-star"></i>
                            </span>
                        @else
                            <span class="text-muted">--No</span>
                        @endif

                    </td>
                    {{-- <td><span class="badge bg-label-primary me-1">Active</span></td> --}}
                    <td class="{{ hideAction($product->status) }}">
                        @canany(['delete-product', 'edit-product', 'show-product'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">

                                    <a href="{{ route('admin.product.manageInventory', $product->id) }}"
                                        class="dropdown-item">
                                        <i class="fa fa-clipboard-list me-1"></i>
                                        Manage Inventory
                                    </a>

                                    @can('show-product')
                                        <a class="dropdown-item" href="{{ route('admin.product.show', $product->id) }}">
                                            <i class="bx bx-show me-1"></i> Show</a>
                                    @endcan
                                    @can('edit-product')
                                        <a class="dropdown-item" href="{{ route('admin.product.edit', $product->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @can('delete-product')
                                        <button data-url="{{ route('admin.product.destroy', $product->id) }}"
                                            data-id="{{ $product->id }}" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    @endcan
                                </div>
                            </div>
                        @endcanany
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($products) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $products->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    @endif
</table>
