@extends('admin.layouts.app')
@section('title', 'Create Permission')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-8">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        Create Permissions
                    </h5>

                    <div class="card-body">

                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form class="ajax-submit-form" data-url="{{ route('admin.employee.storePermission') }}"
                                    data-method="POST" enctype="multipart/form-data">

                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-3 text-right mt-1">
                                            <label for="" class="form-label">Module</label>
                                        </div>

                                        <div class="col-md-9">
                                            <select class="form-select" name="module" id="module">
                                                <option value="product">product</option>
                                                <option value="vehicle_make">vehicle make</option>
                                                <option value="vehicle_type">vehicle type</option>
                                                <option value="vehicle_model">vehicle model</option>
                                                <option value="wholesale_plan">wholesale plan</option>
                                                <option value="customer">customer</option>
                                                <option value="department">department</option>
                                                <option value="employee">employee</option>
                                                <option value="setting">setting</option>
                                                <option value="order">order</option>
                                            </select>



                                        </div>
                                    </div>

                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-3 text-right mt-1">
                                            <label for="" class="form-label">Name</label>
                                        </div>

                                        <div class="col-md-9">

                                            <input class="form-control " type="text" name="permission" value=""
                                                id="permission">


                                        </div>
                                    </div>


                                    <div class="row mt-4 mb-2">
                                        <div class="col-md-9 offset-md-3">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> Save Permission
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

        <div class="container">
            {{-- permision list --}}
            <div class="row">
                <div class="col-xl">
                    <div class="card mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-dark text-uppercase">Permissions : </h5>

                        </div>
                        <div class="card-body">
                            <div class="row">


                                <div class="row">
                                    <div class="col-sm-12 py-2">
                                        {{-- <label class="form-label" for="basic-default-fullname">Module : </label> --}}
                                        @foreach ($permissions as $module => $modulePermissions)
                                            <div class="py-2">
                                                <p class="text-capitalize mb-1"><b>{{ $module }} :</b></p>
                                                <div class="row">
                                                    @foreach ($modulePermissions as $permissions)
                                                        <div class="text-capitalize col-lg-3 col-md-6 col-sm-12">
                                                            {{ $permissions->name }}</div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endforeach

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @endsection
