@extends('admin.layouts.app')
@section('title', 'Customers List')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card px-4">
            <div class="title-n-btn ">
                <h4 class="">Orders</h4>
                <div class="search-flex mt-2">
                    <div class="d-flex col-12">
                        <div class="input-group input-group-merge mx-2">
                            <span class="input-group-text" id="basic-addon-search31"><i class="bx bx-search"></i></span>
                            <input type="text" id="search" class="form-control" placeholder="Search..."
                                aria-label="Search..." aria-describedby="basic-addon-search31" />
                        </div>
                        <button type="button" class="btn btn-info" data-bs-toggle="offcanvas" href="#filterPanel"
                            role="button" aria-controls="filterPanel">
                            <i class="fas fa-filter"></i>
                        </button>
                        {{-- <button class="btn btn-info" data-bs-toggle="offcanvas" href="#form-filter" role="button"
                            aria-controls="form-filter">
                            <i class="fas fa-filter"></i>
                        </button> --}}
                        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel" aria-labelledby="filterPanel"
                            aria-modal="true" role="dialog">
                            {{-- <div class="offcanvas offcanvas-end " tabindex="-1" id="form-filter" aria-labelledby="form-filter"
                            aria-modal="true" role="dialog"> --}}
                            <div class="offcanvas-header border-bottom">
                                <h5 class="offcanvas-title text-uppercase" id="offcanvasRightLabel">
                                    Apply Filter
                                </h5>
                                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                                    aria-label="Close"></button>
                            </div>

                            <div class="offcanvas-body p-0" id="form-filter">
                                <div class="acitivity-timeline p-4">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Per Page</label>
                                            <select id="per_page" name="" class="form-select w-100">
                                                @foreach (perPage() as $key => $value)
                                                    <option value="{{ $key }}">{{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Order Status</label>
                                            <select id="status_filter" class="form-select w-100">
                                                <option value="">All</option>
                                                @foreach (\App\Helpers\CommonHelper::$orderSatuses as $key => $label)
                                                    <option value="{{ $key }}">{{ $label }}</option>
                                                @endforeach
                                            </select>
                                        </div>




                                        <div class="col-md-12 mt-2">
                                            <button id="applyFilter" type="submit"
                                                class="filter-btn btn btn-info btn-border me-1">
                                                <i class="bx bx-check"></i>Apply Filter</button>
                                            </button>
                                            <a id="clearFilter" href="" class="btn btn-outline-secondary mt-2">
                                                <i class="bx bx-refresh"></i> Clear
                                            </a>
                                        </div>



                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>



            <input type="hidden" id="pageUrl" value="{{ route('admin.orders.index') }}">
            <div class="row">
                <div class="col-md-12">
                    <div id="pagination-table">
                        @include('admin.order.pagination')
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- / Content -->
@endsection
