@extends('admin.layouts.app')
@section('title', 'Department List')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-12">
                <!-- Hoverable Table rows -->
                <div class="card px-4 pt-4 pb-4">

                    <h4 class="pt-4">Departments</h4>





                    <div class="row">
                        <div class="col-md-12">
                            <div id="pagination-table">
                                <table id="" class=" table table-hover responsive">
                                    <thead>
                                        <tr>
                                            <th>

                                                Name

                                                </span>
                                            </th>
                                            <th>

                                                Created at



                                            </th>
                                            <th> Actions</span></th>
                                        </tr>
                                    </thead>
                                    @if (isset($departments) && count($departments) > 0)
                                        <tbody class="table-border-bottom-0">

                                            @foreach ($departments as $department)
                                                <tr>

                                                    <td class="text-capitalize">{{ $department->name }}</td>
                                                    <td>{{ dateInList($department->created_at) }}</td>
                                                    @php
                                                        $fixedDeptsIDS = [6, 7, 8, 9, 10];
                                                    @endphp

                                                    <td>
                                                        @if (!in_array($department->id, $fixedDeptsIDS))
                                                            <div class="d-flex">

                                                                @can('edit-department')
                                                                    <a class="btn-role"
                                                                        href="{{ route('admin.department.edit', $department->id) }}">
                                                                        <i class="bx bx-edit"></i></a>
                                                                @endcan
                                                                @can('delete-department')
                                                                    <button class="delete-btn btn-role"
                                                                        data-url="{{ route('admin.department.destroy', $department->id) }}"
                                                                        data-id="{{ $department->id }}"><i
                                                                            class="bx bx-trash me-1"></i>
                                                                    </button>
                                                                @endcan
                                                            </div>
                                                        @else
                                                            <span class="badge bg-secondary">Fixed</span>
                                                        @endif



                                                    </td>



                                                </tr>
                                            @endforeach
                                        </tbody>


                                    @endif
                                </table>
                                <tfoot>
                                    <tr>
                                        <td class="" colspan="6">

                                        </td>
                                    </tr>
                                </tfoot>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>

    <!-- / Content -->
@endsection
