@extends('admin.layouts.app')
@section('title', 'Edit Customer')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Customer</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.customer.update', $customer->id) }}"
                            data-method="POST" enctype="multipart/form-data">
                            @method('PUT')

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="full_name" type="text" class="form-control" id="basic-default-name"
                                        value="{{ old('full_name', $customer->full_name) }}" />

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="address">Wholesale ID</label>
                                <div class="col-sm-10">
                                    @if ($customer->wholesale_plan_id)
                                        <p>{{ $customer->wholesale_plan_id }}</p>
                                    @else
                                        <p class="text-danger">No Wholesale Plan record!</p>
                                    @endif

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="mobile_number">Mobile Number</label>
                                <div class="col-sm-10">
                                    <input name="mobile_number" type="tel" class="w-100 form-control" id="phone"
                                        value="{{ old('mobile_number', $customer->mobile_number) }}" />
                                    <input type="hidden" name="dial_code" id="dial_code"
                                        value="{{ $customer->dial_code }}">
                                    <input type="hidden" name="dial_code_iso" id="dial_code_iso"
                                        value="{{ $customer->dial_code_iso }}">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="email">Email</label>
                                <div class="col-sm-10">
                                    <input name="email" type="email" class="form-control" id="email"
                                        value="{{ old('email', $customer->email) }}" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Image</label>
                                <div class="col-sm-10">
                                    {{-- <input class="form-control" type="file" id="formFileMultiple" multiple /> --}}
                                    <input type="file" name="image" class="form-control" id="image">

                                    <div class="old-image">
                                        <h6 class="pt-3">Current Image</h6>
                                        <div class="row">


                                            <div class="col-lg-3 col-md-6 col-sm-12 pb-3">

                                                <img width="100" src="{{ asset($customer->image ?: DEFAULT_PATH) }}"
                                                    alt="" class="h-100 ">




                                            </div>


                                        </div>


                                    </div>


                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="description">Description</label>
                                <div class="col-sm-10">
                                    <textarea name="description" id="description" class="form-control " cols="30" rows="10"> {{ old('description', $customer->description) }}</textarea>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option {{ old('status', $customer->status) == $key ? 'selected' : '' }}
                                                value="{{ $key }}">{{ $value }}</option>
                                        @endforeach


                                    </select>

                                </div>
                            </div>


                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-12">

                <div class="plans-wrapper ">
                    <div class="card px-4 py-0 mb-4">
                        <div class="wholesale-header pt-4">
                            <div class="titles">
                                <h5 class="">Wholesale Plans: </h5>
                                @if ($assignedWholesalePlans && count($assignedWholesalePlans) > 0)
                                    <h6 class="text-danger">#{{ $customer->wholesale_plan_id }}</h6>
                                @endif
                            </div>

                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#discountModal">Assign Wholesale Plan</button>
                        </div>

                        {{-- discount modal --}}
                        <div class="modal fade" id="discountModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <form class="ajax-submit-form" data-method="POST"
                                    data-url="{{ route('admin.customer.applyDiscount', $customer->id) }}">


                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Apply Wholesale Discount
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>

                                        <div class="modal-body">



                                            <div class="mb-3">
                                                <label for="wholesale_id" class="col-form-label">Wholesale Plan
                                                    List:</label>
                                                <select name="wholesale_id" id="wholesale_id" class="form-control">
                                                    <option value="">Select Plan</option>
                                                    @foreach ($wholesalePlans as $wholesalePlan)
                                                        <option data-name="{{ $wholesalePlan->title }}"
                                                            value="{{ $wholesalePlan->id }}"
                                                            {{ old('wholesale_id', $activePlan->original_plan_id ?? '') == $wholesalePlan->id ? 'selected' : '' }}>
                                                            {{ $wholesalePlan->title }}
                                                        </option>
                                                    @endforeach

                                                </select>

                                            </div>
                                            <div class="mb-3">
                                                <label for="start_discount_date" class="col-form-label">Start
                                                    Date:</label>

                                                <input type="date" class="form-control" id="start_discount_date"
                                                    name="start_discount_date">
                                            </div>



                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary">Apply Discount</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        {{-- display in table --}}
                        @if ($assignedWholesalePlans && count($assignedWholesalePlans) > 0)
                            <div class="card-body px-0">
                                <div class="table-responsive">
                                    <table class="table table-bordered align-middle text-center">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Title</th>
                                                <th>Status</th>

                                                <th>Price (USD)</th>
                                                <th>Price (MMK)</th>

                                                <th>Start Date</th>
                                                <th>End Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($assignedWholesalePlans as $plan)
                                                <tr>
                                                    <td>{{ $plan->title }}</td>
                                                    <td>
                                                        {!! \App\Helpers\CommonHelper::renderStatusBadges($plan->status) !!}
                                                    </td>

                                                    <td>{{ $plan->price_in_usd }}</td>
                                                    <td>{{ $plan->price_in_mmk }}</td>

                                                    <td>{{ $plan->start_date }}</td>
                                                    <td>{{ $plan->end_date }}</td>
                                                    <td>
                                                        @if ($plan->status === ACTIVE || $plan->status === SCHEDULED)
                                                            <form class="ajax-submit-form"
                                                                data-url="{{ route('admin.customer.deactivateDiscount', $customer->id) }}"
                                                                data-method="POST" data-confirm ="update-status"
                                                                enctype="multipart/form-data">
                                                                @method('PUT')

                                                                <input type="hidden" name="discount_id"
                                                                    value="{{ $plan->id }}">
                                                                <input type="hidden" name="action_type"
                                                                    value="{{ $plan->status === ACTIVE ? DEACTIVE : CANCELLED }}">

                                                                {!! \App\Helpers\CommonHelper::renderActionButtons($plan->status) !!}
                                                            </form>
                                                        @else
                                                            <span class="text-muted">--</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        @else
                            <div class="text-info pb-3">
                                This Customer have no assigned wholesale plans.
                                <div>
                        @endif
                    </div>
                </div>

                @if ($customer->addresses && count($customer->addresses) > 0)
                    <div class="addresses">

                        <div class="card px-4 mb-4">

                            <h5 class="pt-5">Address list: </h5>



                            <div class="card-body px-0">
                                <div class="row mb-3">
                                    @foreach ($customer->addresses as $address)
                                        <div class="address col-lg-4 col-sm-6 py-2">
                                            <div class="d-flex pb-2">
                                                <h6 class="m-0 ">Address {{ $loop->iteration }} :
                                                    @if ($address->is_default)
                                                        <span class="badge-custom">Default</span>
                                                    @endif

                                                </h6>

                                            </div>

                                            <p> {{ $address->address_line1 }}<br>
                                                @if (!@empty($address->address_line2))
                                                    {{ $address->address_line2 }}
                                                @endif
                                                {{ $address->city }},
                                                {{ $address->state }}
                                                Myanmar,
                                                {{ $address->pincode }}
                                            </p>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                    </div>
                @endif
            </div>




        </div>

    </div>



    <!-- / Content -->
@endsection
@section('scripts')
    <script>
        let initialCountry = '{{ strtolower($customer->dial_code_iso) }}';
        $(document).ready(function() {


            $(document).on('click', '.delete-image', function() {
                let imageId = $(this).data('id');
                let url = $(this).data('url');
                let button = $(this);

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You want to delete this image?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: url,
                            type: 'DELETE',

                            success: function(res) {
                                button.closest('.image-container').remove();
                                Swal.fire({
                                    title: 'Deleted!',
                                    text: 'Image has been deleted.',
                                    icon: 'success'
                                }).then((result) => {

                                    // if (result.isConfirmed || result.isDismissed) {
                                    //     location
                                    //         .reload();
                                    // }
                                });
                            },
                            error: function() {
                                Swal.fire('Error!', 'Something went wrong.', 'error');
                            }
                        });
                    }
                });
            });


            //flat picker strat discount date

            flatpickr("#start_discount_date", {
                maxDate: new Date().fp_incr(.4 * 365),
                minDate: "today",
                dateFormat: "d-m-Y",
            });
        });
    </script>
@endsection
