<?php

namespace Database\Seeders;

use App\Models\shipping_address;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ShippingAddressSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();

        foreach (range(1, 50) as $customerId) {
            $addressCount = rand(1, 2);

            for ($i = 0; $i < $addressCount; $i++) {
                shipping_address::create([
                    'customer_id' => $customerId,
                    'address_line1' => $faker->streetAddress,
                    'address_line2' => $faker->secondaryAddress,
                    'city' => $faker->city,
                    'state' => $faker->state,
                    'postal_code' => $faker->postcode,
                    'is_default' => $i === 0 ? 1 : 0,
                ]);
            }
        }
    }
}
