<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VehicleModel extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'vehicle_type_id',
        'vehicle_make_id',
        'name',
        'status'
    ];

    public function vehicleMake()
    {
        return $this->belongsTo(VehicleMake::class);
    }
    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class);
    }
    public function compatibleProducts()
    {
        return $this->belongsToMany(Product::class, 'product_vehicle_compatibility');
    }
    public function getPaginatedData($request)
    {
        $query = self::withTrashed()->whereIn('status', [0, 1]);

        $perPage = $request->input('per_page', 10);
        $sortBy = $request->get('sort_by');
        $allowedSortColumns = ['id', 'name', 'status', 'created_at']; // add only valid DB columns here

        // Default to 'vehicle_models.id' if invalid or empty
        $sortBy = in_array($sortBy, $allowedSortColumns) ? 'vehicle_models.' . $sortBy : 'vehicle_models.id';

        $sortOrder = $request->get('sort_order', 'desc');
        $sortOrder = in_array(strtolower($sortOrder), ['asc', 'desc']) ? $sortOrder : 'desc';

        if ($request->has('keyword') && $request->get('keyword')) {
            $keyword = $request->keyword;
            $query->where(function ($q) use ($keyword) {
                $q->where('name', 'like', "%$keyword%")
                    ->orWhere('status', 'like', "%$keyword%")
                    ->orWhere('id', 'like', "%$keyword%");
            });
        }

        if ($request->has('status') && $request->get('status') != '') {
            $query->where('status', $request->status);
        }

        if ($request->has('vehicle_make') && $request->get('vehicle_make') != '') {

            $query->where('vehicle_make_id', (int) $request->vehicle_make);
        }
        // dd($query->orderBy($sortBy, $sortOrder)->paginate($perPage));
        return $query->orderBy($sortBy, $sortOrder)->paginate($perPage);
    }
}
