<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;
    protected $table = 'settings';
    protected $fillable = [
        'key_name',
        'value',
    ];
    public $timestamp = true;

    public static function setValue($key, $value = null)
    {
        if (is_array($key)) {
            foreach ($key as $k => $v) {
                self::updateOrCreate([
                    ['key_name' => $k],
                    ['value' => $v]
                ]);
            }
            return true;
        }
        return self::updateOrCreate(
            ['key_name' => $key],
            ['value' => $value]
        );
    }

    public static function getValue($key)
    {
        if (is_array($key)) {
            return self::whereIn('key_name', $key)
                ->pluck('value', 'key_name')
                ->toArray();
        }
        return self::where('key_name', $key)->value('value');
    }
}
