<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductReview extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_id',
        'rating',
        'review',
        'customer_id',
        'order_id',
        'status',
        'verified_customer'
    ];
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id')->withTrashed();
    }
    public function attachments()
    {
        return $this->hasMany(ReviewAttachment::class, 'review_id');
    }
    public function order()
    {
        return $this->belongsTo(order::class, 'order_id');
    }
    public static function getPaginatedData($request)
    {
        $query = self::with(['product', 'customer']);

        $perPage = $request->input('per_page', 10);
        $sortBy = $request->get('sort_by');
        $allowedSortColumns = ['rating', 'created_at'];
        $sortBy = in_array($sortBy, $allowedSortColumns) ? 'product_reviews.' . $sortBy : 'product_reviews.created_at';

        $sortOrder = $request->get('sort_order', 'desc');
        $sortOrder = in_array(strtolower($sortOrder), ['asc', 'desc']) ? $sortOrder : 'desc';

        if ($request->filled('keyword')) {
            $keyword = $request->keyword;
            $query->where(function ($q) use ($keyword) {
                $q->where('review', 'like', "%$keyword%");
            });
        }

        if ($request->filled('approval_status')) {
            $query->where('status', $request->approval_status);
        }



        return $query->orderBy($sortBy, $sortOrder)->paginate($perPage);
    }
}
