<?php

namespace App\Http\Controllers\Api;

use App\Helpers\CommonHelper;
use App\Http\Controllers\Controller;
use App\Models\BillingAddress;
use App\Models\Cart;
use App\Models\CheckoutAddress;
use App\Models\CustomerAddress;
use App\Models\order;
use App\Models\orderDetail;
use App\Models\OrderStatusLog;
use App\Models\ShippingAddress;
use App\Services\CartService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Services\ProductService;
use Throwable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CheckoutController extends Controller
{
    protected $productService;
    public function __construct(ProductService $productService)
    {
        $this->productService = $productService;
    }
    public function checkoutReview(CartService $cartService)
    {

        $customer = auth()->user();
        $cartOverview =  $cartService->getCartOverview($customer);
        if ($cartOverview['empty_cart']) {
            return CommonHelper::apiResponse(200, __('cart empty'));
        }
        // fetch saved checkout addresses (temp table)
        $shippingAddress = CheckoutAddress::where('customer_id', $customer->id)
            ->where('type', 'shipping')
            ->first();

        $billingAddress = CheckoutAddress::where('customer_id', $customer->id)
            ->where('type', 'billing')
            ->first();

        // add into response
        $data = [
            'products_data' => $cartOverview['products_data'],
            'removed_items' => $cartOverview['removed_items'],
            'payment_summary' => $cartOverview['payment_summary'],
            'cash_back_detail' => $cartOverview['cash_back_detail'],
            'shipping_address' => $shippingAddress,
            'billing_address'  => $billingAddress,
        ];

        return CommonHelper::apiResponse(200, __('checkout review'),  $data);


        //fetch cart detail - original cart count
        /*$originalCartCount = Cart::where('customer_id', $customerId)->count();*/

        /*$deletedInactiveProductMessage = null;*
            if ($cartItems->count() != $originalCartCount) {
                $deletedInactiveProductMessage = "some products are inactive or deleted order placed";
            }*/
    }
    //save address
    public function saveCheckoutAddress(Request $request)
    {
        $customer = auth()->user();

        $rules = [
            'shipping.full_name'     => 'required|string|max:255',
            'shipping.mobile_number' => 'required|string|max:20',
            'shipping.address' => 'required|string|max:255',
            'shipping.city'          => 'required|string|max:100',
            'shipping.state'         => 'required|string|max:100',
            'shipping.country'       => 'required|string|max:100',
            'shipping.pincode'       => 'required|string|max:20',

            'billing_same_as_shipping' => 'required|boolean',

            'billing.full_name'     => 'required_if:billing_same_as_shipping,false|string|max:255',
            'billing.mobile_number' => 'required_if:billing_same_as_shipping,false|string|max:20',
            'billing.address' => 'required_if:billing_same_as_shipping,false|string|max:255',
            'billing.city'          => 'required_if:billing_same_as_shipping,false|string|max:100',
            'billing.state'         => 'required_if:billing_same_as_shipping,false|string|max:100',
            'billing.country'       => 'required_if:billing_same_as_shipping,false|string|max:100',
            'billing.pincode'       => 'required_if:billing_same_as_shipping,false|string|max:20',
        ];

        $attributes = [
            'shipping.full_name'     => __('Shipping Full Name'),
            'shipping.mobile_number' => __('Shipping Mobile Number'),
            'shipping.address'       => __('Shipping Address'),
            'shipping.country'       => __('Shipping Country'),
            'shipping.state'         => __('Shipping State'),
            'shipping.city'          => __('Shipping City'),
            'shipping.pincode'       => __('Shipping Pincode'),

            'billing.full_name'     => __('Billing Full Name'),
            'billing.mobile_number' => __('Billing Mobile Number'),
            'billing.address'       => __('Billing Address'),
            'billing.country'       => __('Billing Country'),
            'billing.state'         => __('Billing State'),
            'billing.city'          => __('Billing City'),
            'billing.pincode'       => __('Billing Pincode'),
        ];

        $validation = Validator::make($request->all(), $rules, [], $attributes);

        if ($validation->fails()) {
            return CommonHelper::apiResponse(400, $validation->errors());
        }
        // save shipping
        CheckoutAddress::updateOrCreate(
            ['customer_id' => $customer->id, 'type' => 'shipping'],
            $request->shipping
        );

        if (!$request->billing_same_as_shipping) {
            // save billing only if different
            CheckoutAddress::updateOrCreate(
                ['customer_id' => $customer->id, 'type' => 'billing'],
                $request->billing
            );
        } else {
            // optional: remove any old billing record
            CheckoutAddress::where('customer_id', $customer->id)
                ->where('type', 'billing')
                ->delete();
        }

        return CommonHelper::apiResponse(200, __('Checkout addresses saved'));
    }
    public function getCheckoutAddress(Request $request)
    {
        $customer = auth()->user();

        // Fetch addresses from temp table
        $shipping = CheckoutAddress::where('customer_id', $customer->id)
            ->where('type', 'shipping')
            ->first();

        $billing = CheckoutAddress::where('customer_id', $customer->id)
            ->where('type', 'billing')
            ->first();

        // Determine if billing is same as shipping
        $billingSameAsShipping = false;
        if (!$billing && $shipping) {
            $billingSameAsShipping = true;
        }

        $data = [
            'shipping' => $shipping ? [
                'full_name'     => $shipping->full_name,
                'mobile_number' => $shipping->mobile_number,
                'address'       => $shipping->address,
                'city'          => $shipping->city,
                'state'         => $shipping->state,
                'country'       => $shipping->country,
                'pincode'       => $shipping->pincode,
            ] : null,
            'billing_same_as_shipping' => $billingSameAsShipping,
            'billing' => $billing ? [
                'full_name'     => $billing->full_name,
                'mobile_number' => $billing->mobile_number,
                'address'       => $billing->address,
                'city'          => $billing->city,
                'state'         => $billing->state,
                'country'       => $billing->country,
                'pincode'       => $billing->pincode,
            ] : null,
        ];

        return CommonHelper::apiResponse(200, __('Checkout addresses fetched'), $data);
    }
}
