<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Helpers\CommonHelper;
use App\Models\Customer;
use App\Models\WholesaleIdPlan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Throwable;
use Illuminate\Support\Facades\Log;
use Illuminate\Database\QueryException;
use Illuminate\Validation\Rule;


class WholesaleIDController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:list-wholesale_plan')->only('index');
        $this->middleware('permission:list-wholesale_plan')->only(['create', 'store']);
        $this->middleware('permission:edit-wholesale_plan')->only(['edit', 'update']);
        $this->middleware('permission:edit-wholesale_plan')->only(['edit', 'show']);
        $this->middleware('permission:delete-wholesale_plan')->only(['destroy']);
    }
    public function index(Request $request)
    {
        $wholesale_id_plans = WholesaleIdPlan::getPaginatedData($request);
        if ($request->ajax()) {
            return response()->json([
                'data' => view('admin.wholesleId.pagination', compact('wholesale_id_plans'))->render()
            ]);
        }
        return view('admin.wholesleId.index', compact('wholesale_id_plans'));
    }

    public function create()
    {
        DB::beginTransaction();
        try {
            $currrncyRate = Setting::getValue('usd_to_mmk');
            // $customers = Customer::where('status', 1)->whereNull('wholesale_plan_id')->get();
            DB::commit();
            $currrncyRate = Setting::getValue(['usd_to_mmk', 'usd_to_rmb']);
            $currrncyRateMmk = $currrncyRate['usd_to_mmk'] ?? null;
            $currrncyRateRmb = $currrncyRate['usd_to_rmb'] ?? null;

            return view('admin.wholesleId.create', compact('currrncyRate', 'currrncyRateMmk', 'currrncyRateRmb'));
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        $validation = Validator::make($request->all(), [
            'title' => 'required|string|max:255|unique:wholesale_id_plans,title',
            'price_in_usd' => 'required|numeric|min:0',
            'price_in_mmk' => 'required|numeric|min:0',
            'price_in_rmb' => 'required|numeric|min:0',
            'min_order_amt_usd' => 'required|numeric|min:0',
            'min_order_amt_mmk' => 'required|numeric|min:0',
            'min_order_amt_rmb' => 'required|numeric|min:0',
            // 'assigned_customer' => 'array|nullable',
            // 'assigned_customer.*' => 'exists:customers,id',
            'discount' => 'required|numeric|between:0,100|gt:0|unique:wholesale_id_plans,discount',
            'status' => 'required|in:0,1',
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        try {
            $currrncyRate = Setting::getValue(['usd_to_mmk', 'usd_to_rmb']);
            $currrncyRateMmk = $currrncyRate['usd_to_mmk'];
            $currrncyRateRmb = $currrncyRate['usd_to_rmb'];

            //price clulation in currenicies
            $priceInUsd = $request->price_in_usd;
            $priceInMmk = $request->price_in_mmk;
            $priceInUsd = $priceInMmk / $currrncyRateMmk;
            $priceInMmk = $priceInUsd * $currrncyRateMmk;
            $priceInRmb = $priceInUsd * $currrncyRateRmb;

            // min order amount calculation
            $minOderAmtInUsd = $request->min_order_amt_usd;
            $minOderAmtInMmk = $request->min_order_amt_mmk;
            $minOderAmtInUsd = $minOderAmtInMmk / $currrncyRateMmk;
            $minOderAmtInMmk = $minOderAmtInUsd * $currrncyRateMmk;
            $minOderAmtInRmb = $minOderAmtInUsd * $currrncyRateRmb;


            $wholesalePlan = WholesaleIdPlan::create([
                'title' => $request->title,
                'price_in_usd' => $priceInUsd,
                'price_in_mmk' => $priceInMmk,
                'price_in_rmb' => $priceInRmb,
                'min_order_amt_usd' => $minOderAmtInUsd,
                'min_order_amt_mmk' => $minOderAmtInMmk,
                'min_order_amt_rmb' => $minOderAmtInRmb,
                'discount' => $request->discount,
                'status' => $request->status
            ]);
            //update assign plan id to customer
            /* foreach ($request->assigned_customer as $assigned_customer) {
                Customer::where('id', $assigned_customer)->update([
                    'wholesale_plan_id' => $wholesalePlan->id
                ]);
            }*/
            DB::commit();
            $extra = [
                'redirect' => route('admin.wholesale-plan.index'),
            ];
            return CommonHelper::jsonResponseWeb(200, 'wholesale discount plan added successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }

    public function edit($id)
    {
        DB::beginTransaction();
        try {

            $plan = WholesaleIdPlan::findOrFail($id);
            // $customers = Customer::where('status', 1)->get();

            $currrncyRate = Setting::getValue(['usd_to_mmk', 'usd_to_rmb']);
            $currrncyRateMmk = $currrncyRate['usd_to_mmk'] ?? null;
            $currrncyRateRmb = $currrncyRate['usd_to_rmb'] ?? null;
            DB::commit();
            return view('admin.wholesleId.edit', compact('plan', 'currrncyRateMmk', 'currrncyRateRmb'));
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        $plan = WholesaleIdPlan::findOrFail($id);

        $validation = Validator::make($request->all(), [
            'title' => ['required', 'string', 'max:255', Rule::unique('wholesale_id_plans', 'title')->ignore($id)],
            'price_in_usd' => 'required|numeric|min:0',
            'price_in_mmk' => 'required|numeric|min:0',
            'price_in_rmb' => 'required|numeric|min:0',
            'discount' => ['required', 'numeric', 'between:0,100', 'gt:0', Rule::unique('wholesale_id_plans', 'discount')->ignore($id)],
            //'min_order_amt' => ['required', 'numeric', 'min:1', Rule::unique('wholesale_id_plans', 'min_order_amt')->ignore($id)],
            'min_order_amt_usd' => 'required|numeric|min:1',
            'min_order_amt_mmk' => 'required|numeric|min:1',
            'min_order_amt_rmb' => 'required|numeric|min:1',
            'status' => 'required|in:0,1',
            // 'assigned_customer' => 'array|nullable',
            // 'assigned_customer.*' => 'exists:customers,id',
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }

        try {
            $priceInUsd = $plan->price_in_usd;
            $priceInMmk = $plan->price_in_mmk;
            $priceInRmb = $plan->price_in_rmb;
            $minOrderAmtUsd = $plan->min_order_amt_usd;
            $minOrderAmtMmk = $plan->min_order_amt_mmk;
            $minOrderAmtRmb = $plan->min_order_amt_rmb;

            $currrncyRate = Setting::getValue(['usd_to_mmk', 'usd_to_rmb']);
            $currrncyRateMmk = $currrncyRate['usd_to_mmk'];
            $currrncyRateRmb = $currrncyRate['usd_to_rmb'];
            if ($request->has('price_in_usd') || $request->has('price_in_mmk') || $request->has('price_in_rmb')) {

                $priceInUsd = $request->price_in_usd;
                $priceInMmk = $request->price_in_mmk;
                //$priceInRmb = $request->price_in_rmb;

                $priceInUsd = $priceInMmk / $currrncyRateMmk;
                $priceInMmk = $priceInUsd * $currrncyRateMmk;
                $priceInRmb = $priceInUsd * $currrncyRateRmb;
            }
            //min order amount edition
            if ($request->has('price_in_usd') || $request->has('price_in_mmk') || $request->has('price_in_rmb')) {

                $minOrderAmtUsd = $request->min_order_amt_usd;
                $minOrderAmtMmk = $request->min_order_amt_mmk;
                //$priceInRmb = $request->price_in_rmb;

                $minOrderAmtUsd = $minOrderAmtMmk / $currrncyRateMmk;
                $minOrderAmtMmk =  $minOrderAmtUsd * $currrncyRateMmk;
                $minOrderAmtRmb =  $minOrderAmtUsd * $currrncyRateRmb;
            }

            //Customer::where('wholesale_plan_id', $id)->update(['wholesale_plan_id' => null]); // Unassign all customers
            //dd($request->wholesale_id);
            $plan->update([
                'title' => $request->title,
                'price_in_usd' => $priceInUsd,
                'price_in_mmk' => $priceInMmk,
                'price_in_rmb' => $priceInRmb,
                'discount' => $request->discount,
                'min_order_amt_usd' => $minOrderAmtUsd,
                'min_order_amt_mmk' => $minOrderAmtMmk,
                'min_order_amt_rmb' => $minOrderAmtRmb,
                'status' => $request->status
            ]);
            /* if ($request->has('assigned_customer')) {
                Customer::whereIn('id', $request->assigned_customer)->update(['wholesale_plan_id' => $id]);
            }*/

            DB::commit();
            $extra = [
                'redirect' => route('admin.wholesale-plan.index'),
            ];
            return CommonHelper::jsonResponseWeb(200, 'wholesale discount plan updated successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function destroy($id)
    {
        DB::beginTransaction();
        $plan = WholesaleIdPlan::findOrFail($id);
        if ($plan->is_default) {
            return CommonHelper::jsonResponseWeb(400, __('basic cant deleted'));
        }
        try {

            $plan->update(['status' => 2]);
            $plan->delete();
            DB::commit();
            $extra = [
                'redirect' => route('admin.wholesale-plan.index')
            ];
            return CommonHelper::jsonResponseWeb(200, 'Wholesale plan ID deleted successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
}
