<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Throwable;
use App\Helpers\CommonHelper;
use App\Models\Setting;
use Illuminate\Support\Facades\DB;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:return-days-setting')->only('returnDays', 'updateReturnDays');
        $this->middleware('permission:tax-setting')->only(['tax', ' updateTax']);
        $this->middleware('permission:currency-conversion-setting')->only(['currencyConversion', 'updateCurrencyConversion']);
        //profile
    }
    public function returnDays()
    {
        //$returnDays = Setting::firstOrNew(['key_name' => 'return_days']);
        $returnDays = Setting::getValue('return_days');
        return view('admin.setting.return-days', compact('returnDays'));
    }
    public function updateReturnDays(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'return_days' => 'required|integer|min:0',
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }

        try {
            Setting::setValue('return_days', $request->return_days);
            $extra = [
                'redirect' => route('admin.setting.returnDays')
            ];
            return CommonHelper::jsonResponseWeb(200, 'Return days updated successfully', [], $extra);
        } catch (Throwable $e) {

            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function currencyConversion()
    {
        $currencies = Setting::getValue(['usd_to_mmk', 'usd_to_rmb']);
        $mmk = $currencies['usd_to_mmk'] ?? null;
        $rmb = $currencies['usd_to_rmb'] ?? null;
        return view('admin.setting.currency-conversion', compact('mmk', 'rmb'));
    }
    public function updateCurrencyConversion(Request $request)
    {
        DB::beginTransaction();
        $data = $request->only(['usd_to_mmk', 'usd_to_rmb']);
        $rules = [];
        if ($request->has('usd_to_mmk')) {
            $rules['usd_to_mmk'] = 'required|numeric|min:1';
        }
        if ($request->has('usd_to_rmb')) {
            $rules['usd_to_rmb'] = 'required|numeric|min:1';
        }
        $validation = Validator::make($data, $rules);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        try {
            Setting::setValue($data);
            if ($request->has('usd_to_mmk')) {
                $mmkRate = $data['usd_to_mmk'];
                DB::statement("update products set price_in_mmk = price_in_usd * ?", [$mmkRate]); // update products table
            }
            if ($request->has('usd_to_rmb')) {
                $rmbRate = $data['usd_to_rmb'];
                DB::statement("update products set price_in_mmk = price_in_usd * ?", [$rmbRate]); // update products table
            }
            DB::commit();
            $extra = [
                'redirect' => route('admin.setting.currency')
            ];
            return CommonHelper::jsonResponseWeb(200, 'Currency conversion and all products MMK price updated successfully and', [], $extra);
        } catch (Throwable $e) {
            DB::rollback();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    public function tax()
    {
        $taxes = Setting::getValue('tax');
        return view('admin.setting.tax', compact('taxes'));
    }
    public function updateTax(Request $request)
    {
        DB::beginTransaction();
        $validation = Validator::make($request->all(), [
            'tax' => 'required|numeric|min:0'
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        try {
            Setting::setValue('tax', $request->tax);
            DB::commit();
            $extra = [
                'redirect' => route('admin.setting.tax')
            ];
            return CommonHelper::jsonResponseWeb(200, 'Tax value updated successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollback();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    //pages for app side
    public function aboutUs()
    {
        $about_us_en = Setting::getValue('about_us_en');
        return view('admin.setting.about-us', compact('about_us_en'));
    }
    public function aboutUsUpdate(Request $request)
    {
        DB::beginTransaction();
        $validation = Validator::make($request->all(), [
            'about_us_en' => 'required'
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        try {
            Setting::setValue('about_us_en', $request->about_us_en);
            DB::commit();
            $extra = [
                'redirect' => route('admin.pages.aboutUs')
            ];
            return CommonHelper::jsonResponseWeb(200, 'About us content updated successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollback();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    //get link for app developer
    public function aboutUsWebView($lang)
    {
        $lang = $lang ?? 'en';
        $result =  Setting::getValue('about_us_en');
        return view('web-views.about-us', compact('result', 'lang'));
    }
    //privacy policy
    public function privacyPolicy()
    {
        $privacy_policy_en = Setting::getValue('privacy_policy_en');
        return view('admin.setting.privacy-policy', compact('privacy_policy_en'));
    }
    public function privacyPolicyUpdate(Request $request)
    {
        DB::beginTransaction();
        $validation = Validator::make($request->all(), [
            'privacy_policy_en' => 'required'
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        try {
            Setting::setValue('privacy_policy_en', $request->privacy_policy_en);
            DB::commit();
            $extra = [
                'redirect' => route('admin.pages.privacyPolicy')
            ];
            return CommonHelper::jsonResponseWeb(200, 'Privacy Policy content updated successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollback();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    //get link for app developer
    public function privacyPolicyWebView($lang)
    {
        $lang = $lang ?? 'en';
        $result =  Setting::getValue('privacy_policy_en');
        return view('web-views.privacy-policy', compact('result', 'lang'));
    }
    //terms and conditions
    public function termsConditions()
    {
        $terms_conditions_en = Setting::getValue('terms_conditions_en');
        return view('admin.setting.terms-conditions', compact('terms_conditions_en'));
    }
    public function termsConditionsUpdate(Request $request)
    {
        DB::beginTransaction();
        $validation = Validator::make($request->all(), [
            'terms_conditions_en' => 'required'
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        try {
            Setting::setValue('terms_conditions_en', $request->terms_conditions_en);
            DB::commit();
            $extra = [
                'redirect' => route('admin.pages.termsConditions')
            ];
            return CommonHelper::jsonResponseWeb(200, 'Terms and Conditions content updated successfully', [], $extra);
        } catch (Throwable $e) {
            DB::rollback();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
    //get link for app developer
    public function  termsConditionsWebView($lang)
    {
        $lang = $lang ?? 'en';
        $result =  Setting::getValue('terms_conditions_en');
        return view('web-views.terns-conditions', compact('result', 'lang'));
    }
}
